/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CFileImpWin32.h,v 1.4 2000/05/13 06:34:21 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CFileImpWin32_h	// [
#define Included_CFileImpWin32_h

#include "pgpClassesConfig.h"
#include "CFileImp.h"

_PGP_BEGIN

// Class CFileImpWin32

class CFileImpWin32 : public CFileImp
{
	friend class CPFLImpFactoryWin32;

private:
	CFileImpWin32() : mFileHandle(INVALID_HANDLE_VALUE) { }
	~CFileImpWin32();

	PGPUInt64	GetLength() const;
	PGPUInt64	GetUniqueFileId() const;

	void	SetIsCompressed(PGPBoolean isCompressed);
	void	SetLength(PGPUInt64 length);

	void	Flush();

	void	Open(const char *path, PGPUInt32 flags);
	void	Close();
	void	Delete(const char *path);
	void	Move(const char *oldPath, const char *newPath);

	void	Read(void *buf, PGPUInt64 pos, PGPUInt32 nBytes) const;
	void	Write(const void *buf, PGPUInt64 pos, PGPUInt32 nBytes) const;

private:
	HANDLE	mFileHandle;

	void	EzSetFilePointer(PGPUInt64 bytes) const;
};

_PGP_END

#endif	// ] Included_CFileImpWin32_h
